# 画面設計書 9-Simple Registry Browser

## 概要

本ドキュメントは、VBCorLibプロジェクトのサンプルアプリケーション「Simple Registry Browser」の画面設計書です。

### 本画面の処理概要

Simple Registry BrowserはVBCorLibライブラリが提供するRegistry、RegistryKeyクラスを使用して、Windowsレジストリを閲覧する画面です。TreeViewコントロールでレジストリキーの階層構造を表示し、ListViewコントロールで選択したキーの値一覧を表示します。Windows標準のregeditと同様の操作感でレジストリを閲覧できます。

**業務上の目的・背景**：Windowsレジストリへのアクセスは、アプリケーション設定の管理やシステム情報の取得において重要な機能です。VBCorLibは.NET FrameworkのMicrosoft.Win32.Registry/RegistryKeyクラスと同様のAPIを提供し、VB6/VBAからも型安全なレジストリ操作が可能です。本画面は、レジストリ読み取り機能の使用方法を開発者に示すことを目的としています。

**画面へのアクセス方法**：Examples/Registry/SimpleRegistryBrowser/SimpleRegistryBrowser.vbpプロジェクトを開き、F5キーで実行することでこの画面が表示されます。

**主要な操作・処理内容**：
1. TreeViewでレジストリキーの階層を展開表示
2. ノードをクリックすると子キーを読み込み
3. ListViewに選択キーの値一覧を表示
4. 値の名前、種別（REG_SZ、REG_DWORD等）、データを表示

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移はありません。

**権限による表示制御**：レジストリキーへのアクセス権限に依存します。アクセス権限のないキーは展開できない場合があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 90 | Registry | 主機能 | レジストリルートキーへのアクセス（ClassesRoot、CurrentConfig、CurrentUser、LocalMachine） |
| 91 | RegistryKey | 主機能 | レジストリキーの操作（GetSubKeyNames、GetValueNames、GetValue、GetValueKind、OpenSubKey） |
| 2 | CorString | 補助機能 | 文字列フォーマット処理（DWord値のフォーマット） |
| 17 | StringBuilder | 補助機能 | バイナリ値の16進数文字列変換（AppendFormat） |
| 1 | CorArray | 補助機能 | キー名のソート処理（Sort） |
| 24 | Comparer | 補助機能 | 大小文字を区別しない比較（CaseInsensitiveComparer） |

## 画面種別

ブラウザ / 一覧・詳細表示

## URL/ルーティング

VB6デスクトップアプリケーションのため、URLルーティングは存在しません。フォームファイル: `Examples/Registry/SimpleRegistryBrowser/Form1.frm`

## 入出力項目

本画面は読み取り専用のブラウザ画面であり、データ入力機能はありません。

## 表示項目

### TreeView1

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ルートキー | String | HKEY_CLASSES_ROOT、HKEY_CURRENT_CONFIG、HKEY_CURRENT_USER、HKEY_LOCAL_MACHINE |
| サブキー | String | 各ルートキー配下のサブキー名 |

### ListView1

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Name | String | 値の名前（デフォルト値は"(Default)"） |
| Type | String | 値の種別（REG_SZ、REG_DWORD等） |
| Data | String | 値のデータ（種別に応じてフォーマット） |

### StatusBar1

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Panel1 | String | 現在選択中のレジストリキーのフルパス |

## イベント仕様

### 1-Form_Load

フォーム読み込み時にListViewのカラムとルートキーを初期化します。

**処理内容**:
1. ListViewのColumnHeaders追加（Name、Type、Data）
2. FillRootKeysでルートキーノードを追加

**コード参照**: 行286-294

```vb
Private Sub Form_Load()
    With ListView1
        .ColumnHeaders.Add , , "Name", 2500
        .ColumnHeaders.Add , , "Type", 1500
        .ColumnHeaders.Add , , "Data", 2500
    End With

    FillRootKeys
End Sub
```

### 2-FillRootKeys（内部関数）

TreeViewにルートキーを追加します。

**処理内容**:
1. "My Computer"ルートノードを追加
2. ClassesRoot、CurrentConfig、CurrentUser、LocalMachineを子ノードとして追加

**コード参照**: 行275-282

### 3-TreeView1_NodeClick

TreeViewノードクリック時にサブキーと値を表示します。

**処理内容**:
1. クリックされたノードからRegistryKeyを取得
2. DisplaySubKeysでサブキーをTreeViewに追加
3. DisplayValuesで値をListViewに表示
4. StatusBarにキー名を表示

**コード参照**: 行299-337

### 4-DisplaySubKeys（内部関数）

サブキーをTreeViewに追加します。

**処理内容**:
1. ノードに子がない場合のみサブキーを読み込み
2. Key.GetSubKeyNamesでサブキー名一覧取得
3. TreeView1.Nodes.Addで子ノード追加

**コード参照**: 行108-133

### 5-DisplayValues（内部関数）

選択キーの値をListViewに表示します。

**処理内容**:
1. ListView1.ListItems.Clearでクリア
2. デフォルト値("(Default)")を追加
3. Key.GetValueNamesで値名一覧取得
4. CorArray.SortでCaseInsensitiveComparerを使用してソート
5. 各値の名前、種別、データを表示

**コード参照**: 行138-197

### 6-ValueToString（内部関数）

値を文字列に変換します。

**処理内容**:
1. 値の種別に応じたフォーマット
2. DWordはFormatDWord（16進数+10進数）
3. BinaryはFormatBinary（16進数列）
4. MultiStringはJoin

**コード参照**: 行202-210

### 7-FormatDWord（内部関数）

DWord値を"0xXXXXXXXX (Y)"形式にフォーマットします。

**処理内容**:
1. CorString.Format("{0:x8} ({0})", Value)で16進数と10進数を両方表示

**コード参照**: 行215-227

### 8-FormatBinary（内部関数）

バイナリ値をスペース区切りの16進数列にフォーマットします。

**処理内容**:
1. StringBuilderで構築
2. 各バイトを{0:x2}形式で変換
3. 末尾のスペースを除去

**コード参照**: 行233-255

## データベース更新仕様

本画面はデータベースを使用しません。レジストリの読み取りのみ行い、書き込みは行いません。

## メッセージ仕様

本画面にメッセージ表示機能はありません。

## 例外処理

| 例外種別 | 対処方法 |
|---------|---------|
| アクセス権限エラー | レジストリキーへのアクセス権限がない場合、サブキーが読み込めない |
| キー不存在 | OpenSubKeyがNothingを返す |

## 備考

- BorderStyle = Fixed Single（サイズ変更不可）
- MaxButton = False, MinButton = False（最大化・最小化ボタン無効）
- MSCOMCTL.OCX（TreeView、ListView、StatusBar、ImageList）を使用
- TreeViewのImageList: Closed（閉じたフォルダ）、Open（開いたフォルダ）
- レジストリ書き込み機能は実装されていない（読み取り専用）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

レジストリキーへのアクセスパターンを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Form1.frm | `Examples/Registry/SimpleRegistryBrowser/Form1.frm` | 行98-100: コメント説明 |

**読解のコツ**: VBCorLibのRegistryクラスは.NET FrameworkのMicrosoft.Win32.Registryと同様のAPIを提供します。静的プロパティ（ClassesRoot、CurrentUser等）でルートキーにアクセスします。

#### Step 2: エントリーポイントを理解する

フォーム読み込みとノードクリックがエントリーポイントです。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/Registry/SimpleRegistryBrowser/Form1.frm` | 行286-294: Form_Load |
| 2-2 | Form1.frm | `Examples/Registry/SimpleRegistryBrowser/Form1.frm` | 行299-337: TreeView1_NodeClick |

**主要処理フロー**:
1. **行287-291**: ListViewカラム設定
2. **行293**: FillRootKeysでルートキー追加
3. **行302**: ノードクリック時にMousePointer変更
4. **行304-328**: ノードの種類に応じてRegistryKey取得
5. **行332-333**: DisplaySubKeys、DisplayValuesで表示更新

#### Step 3: レジストリ読み込み処理を理解する

レジストリからのデータ取得処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Form1.frm | `Examples/Registry/SimpleRegistryBrowser/Form1.frm` | 行108-133: DisplaySubKeys |
| 3-2 | Form1.frm | `Examples/Registry/SimpleRegistryBrowser/Form1.frm` | 行138-197: DisplayValues |

**主要処理フロー（DisplaySubKeys）**:
- **行115**: Key.GetSubKeyNamesでサブキー名取得
- **行124**: TreeView1.Nodes.Addで子ノード追加

**主要処理フロー（DisplayValues）**:
- **行149**: デフォルト値を追加
- **行171-174**: CorArray.Sort(Values, New CaseInsensitiveComparer)
- **行186**: Key.GetValueKind(Values(i))で値の種別取得
- **行192**: Key.GetValue(Values(i))で値のデータ取得

### プログラム呼び出し階層図

```
Form_Load
    │
    ├─ ListView1.ColumnHeaders.Add (3回)
    │
    └─ FillRootKeys
           └─ TreeView1.Nodes.Add
                  ├─ "My Computer" (root)
                  └─ Registry.ClassesRoot/CurrentConfig/CurrentUser/LocalMachine

TreeView1_NodeClick
    │
    ├─ [ルートキー判定]
    │      ├─ Registry.ClassesRoot
    │      ├─ Registry.CurrentConfig
    │      ├─ Registry.CurrentUser
    │      └─ Registry.LocalMachine
    │
    ├─ [サブキー判定]
    │      └─ Registry.*.OpenSubKey(Parts(1))
    │
    ├─ DisplaySubKeys(Node, Key)
    │      ├─ Key.GetSubKeyNames
    │      └─ TreeView1.Nodes.Add (子ノード)
    │
    └─ DisplayValues(Key)
           ├─ ListView1.ListItems.Clear
           ├─ Key.GetValue("") (Default)
           ├─ Key.GetValueNames
           ├─ CorArray.Sort (CaseInsensitiveComparer)
           └─ [各値について]
                  ├─ Key.GetValueKind
                  ├─ Key.GetValue
                  ├─ ValueKindToString
                  └─ ValueToString
                         ├─ FormatDWord
                         └─ FormatBinary
```

### データフロー図

```
[レジストリ]                   [処理]                    [表示]

Registry.ClassesRoot ─────▶ OpenSubKey ───────────────▶ TreeView1
Registry.CurrentUser ─────▶ GetSubKeyNames ───────────▶ (ノード追加)
    :
    ▼
RegistryKey ──────────────▶ GetValueNames ────────────▶ ListView1
                           GetValueKind ──────────────▶ (Type列)
                           GetValue ──────────────────▶ (Data列)
                                                        StatusBar1
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/Registry/SimpleRegistryBrowser/Form1.frm` | ソース | メインフォーム |
| Form1.frx | `Examples/Registry/SimpleRegistryBrowser/Form1.frx` | バイナリ | フォームリソース（アイコン画像） |
| SimpleRegistryBrowser.vbp | `Examples/Registry/SimpleRegistryBrowser/SimpleRegistryBrowser.vbp` | プロジェクト | プロジェクト定義 |
| MSCOMCTL.OCX | 外部 | OCX | TreeView/ListView/StatusBar/ImageListコントロール |
| VBCorLib.dll | 外部 | DLL | VBCorLibライブラリ本体 |
